# -*- coding: utf-8 -*-

#ext_forces.py
#@author: Olivier Lantsoght
#
#Created on 23/05/2019
#Last update on 23/05/2019
#
#Copyright 2019 Universite Catholique de Louvain


import numpy as np

def user_ExtForces(PxF,RxF,VxF,OMxF,AxF,OMPxF,mbs,tsim,ixF):
    """ Compute the external force for a given force point

    :param PxF: the position of the point
    :param RxF: the rotation matrix of the point
    :param VxF: the velocity vector of the point
    :param OMxF: the angular velocity of the point
    :param AxF: the acceleration vector of the point
    :param OMPxF: the angular acceleration of the point
    :param mbs: the Data structure
    :param tsim: the simulation time
    :param ixF: the index of the force point
    
    """
    
    print("user_ExtForces (Template) : This function should not be called")
    
    Fx=0.0
    Fy=0.0
    Fz=0.0
    Mx=0.0
    My=0.0
    Mz=0.0
    idpt=mbs.xfidpt[ixF]
    dxF=mbs.dpt[1:,idpt]
    #==========================================================================
    # BEGIN OF USER CODE
    #==========================================================================
    # Example : contact force with a wall when X coordinate is higher than 1m
    # xlim = 1.0 # m
    # kwall= 1e5 # N/m
    # if PxF[1]>xlim:
    #     Fx = (PxF[1]-xlim)*kwall
    #==========================================================================
    # END OF USER CODE
    #==========================================================================
    Swr=np.zeros(9+1)
    Swr[1:]=np.r_[Fx,Fy,Fz,Mx,My,Mz,dxF]
    return Swr
